/*! Orchid Mahjong Solitaire v1.0.0 - Production Ready Widget | (c) 2025 Five Cities Orchid Society */
!function(){"use strict";window.OrchidMahjong=window.OrchidMahjong||{};const TILE_TYPES={PETALS:{base:"petals",count:9,copies:4,theme:"orchid-petals"},STEMS:{base:"stems",count:9,copies:4,theme:"orchid-stems"},LABELS:{base:"labels",count:9,copies:4,theme:"orchid-labels"},WINDS:{base:"winds",count:4,copies:4,values:["N","E","S","W"],theme:"greenhouse-fans"},DRAGONS:{base:"dragons",count:3,copies:4,values:["Gold","Silver","Bronze"],theme:"award-ribbons"},FLOWERS:{base:"flowers",count:8,copies:1,values:["Phalaenopsis","Cattleya","Dendrobium","Paphiopedilum","Vanda","Oncidium","Cymbidium","Masdevallia"],theme:"orchid-portraits"}},THEMES={fcos:{name:"FCOS Purple/Green/Beach",primary:"#4B0082",secondary:"#CDE4BC",accent:"#e6f7ff",background:"#f8f9fa",tile:"#ffffff",selected:"#FFD700",matched:"#90EE90"},neutral:{name:"Classic Neutral",primary:"#2c3e50",secondary:"#ecf0f1",accent:"#3498db",background:"#f5f5f5",tile:"#fefefe",selected:"#f39c12",matched:"#27ae60"},highContrast:{name:"High Contrast",primary:"#000000",secondary:"#ffffff",accent:"#ffff00",background:"#ffffff",tile:"#ffffff",selected:"#ffff00",matched:"#00ff00"}},LAYOUTS={turtle:{name:"Turtle",difficulty:"Normal",pattern:"classic_turtle"},dragon:{name:"Dragon",difficulty:"Hard",pattern:"classic_dragon"},pyramid:{name:"Pyramid",difficulty:"Easy",pattern:"classic_pyramid"},orchid:{name:"Orchid Bloom",difficulty:"Normal",pattern:"orchid_flower"},greenhouse:{name:"Greenhouse",difficulty:"Hard",pattern:"greenhouse_shape"},butterfly:{name:"Butterfly",difficulty:"Expert",pattern:"butterfly_wings"},fortress:{name:"Fortress",difficulty:"Expert",pattern:"fortress_walls"},garland:{name:"Orchid Garland",difficulty:"Normal",pattern:"flower_garland"}};class OrchidMahjongGame{constructor(container,options={}){this.container="string"==typeof container?document.querySelector(container):container,this.options={theme:"fcos",layout:"turtle",difficulty:"normal",sound:!1,music:!1,highlights:!0,allowWildGroups:!0,seed:null,...options},this.gameState={tiles:[],selectedTiles:[],matchedTiles:new Set,moves:0,score:0,startTime:null,endTime:null,isPaused:!1,undoStack:[],redoStack:[]},this.eventHandlers={},this.init()}init(){this.createGameHTML(),this.applyTheme(this.options.theme),this.generateTiles(),this.createLayout(),this.bindEvents(),this.loadSettings(),this.startTimer(),this.emit("init",{options:this.options})}createGameHTML(){this.container.innerHTML=`<div class="orchid-mahjong-widget" data-theme="${this.options.theme}"><div class="game-header"><div class="game-stats"><div class="stat-item"><span class="stat-label">Time</span><span class="stat-value" id="om-timer">00:00</span></div><div class="stat-item"><span class="stat-label">Moves</span><span class="stat-value" id="om-moves">0</span></div><div class="stat-item"><span class="stat-label">Pairs</span><span class="stat-value" id="om-pairs">72</span></div><div class="stat-item"><span class="stat-label">Score</span><span class="stat-value" id="om-score">0</span></div></div><div class="game-controls"><button class="control-btn" id="om-undo" title="Undo (U)" aria-label="Undo last move"><span class="btn-icon">↶</span></button><button class="control-btn" id="om-redo" title="Redo (R)" aria-label="Redo move"><span class="btn-icon">↷</span></button><button class="control-btn" id="om-hint" title="Hint (H)" aria-label="Show hint"><span class="btn-icon">💡</span></button><button class="control-btn" id="om-shuffle" title="Shuffle (S)" aria-label="Shuffle tiles"><span class="btn-icon">🔀</span></button><button class="control-btn" id="om-new" title="New Game (T)" aria-label="Start new game"><span class="btn-icon">🔄</span></button><button class="control-btn" id="om-settings" title="Settings" aria-label="Open settings"><span class="btn-icon">⚙️</span></button></div></div><div class="game-board-container"><div class="game-board" id="om-board" role="grid" aria-label="Mahjong tile board"></div></div><div class="settings-panel" id="om-settings-panel" style="display: none;"><div class="settings-header"><h3>Settings</h3><button class="close-btn" id="om-close-settings">&times;</button></div><div class="settings-content"><div class="setting-group"><label>Theme</label><select id="om-theme-select"><option value="fcos">FCOS Purple/Green</option><option value="neutral">Classic Neutral</option><option value="highContrast">High Contrast</option></select></div><div class="setting-group"><label>Layout</label><select id="om-layout-select"><option value="turtle">Turtle (Normal)</option><option value="dragon">Dragon (Hard)</option><option value="pyramid">Pyramid (Easy)</option><option value="orchid">Orchid Bloom (Normal)</option><option value="greenhouse">Greenhouse (Hard)</option><option value="butterfly">Butterfly (Expert)</option><option value="fortress">Fortress (Expert)</option><option value="garland">Orchid Garland (Normal)</option></select></div><div class="setting-group"><label><input type="checkbox" id="om-highlights"> Show tile highlights</label></div><div class="setting-group"><label><input type="checkbox" id="om-sound"> Sound effects</label></div><div class="setting-group"><button class="action-btn" id="om-reset-stats">Reset Statistics</button></div></div></div><div class="win-overlay" id="om-win-overlay" style="display: none;"><div class="win-content"><h2>🌺 Congratulations! 🌺</h2><p>You've completed the Orchid Mahjong!</p><div class="win-stats"><div class="win-stat"><strong>Time:</strong> <span id="om-win-time">--:--</span></div><div class="win-stat"><strong>Moves:</strong> <span id="om-win-moves">0</span></div><div class="win-stat"><strong>Score:</strong> <span id="om-win-score">0</span></div></div><div class="win-actions"><button class="action-btn" id="om-play-again">Play Again</button><button class="action-btn secondary" id="om-change-layout">Change Layout</button></div></div></div><div class="sr-only" id="om-announcements" aria-live="polite" aria-atomic="true"></div></div>`}generateTiles(){this.gameState.tiles=[];let tileId=0;for(let value=1;value<=9;value++)for(let copy=0;copy<4;copy++)this.gameState.tiles.push({id:tileId++,type:"petals",value:value,suit:"petals",canMatch:other=>"petals"===other.type&&other.value===value,display:this.createPetalsTile(value),aria:`Petals ${value}`});for(let value=1;value<=9;value++)for(let copy=0;copy<4;copy++)this.gameState.tiles.push({id:tileId++,type:"stems",value:value,suit:"stems",canMatch:other=>"stems"===other.type&&other.value===value,display:this.createStemsTile(value),aria:`Stems ${value}`});for(let value=1;value<=9;value++)for(let copy=0;copy<4;copy++)this.gameState.tiles.push({id:tileId++,type:"labels",value:value,suit:"labels",canMatch:other=>"labels"===other.type&&other.value===value,display:this.createLabelsTile(value),aria:`Labels ${value}`});const winds=["N","E","S","W"];winds.forEach(wind=>{for(let copy=0;copy<4;copy++)this.gameState.tiles.push({id:tileId++,type:"winds",value:wind,suit:"honors",canMatch:other=>"winds"===other.type&&other.value===wind,display:this.createWindTile(wind),aria:`Wind ${wind}`})});const dragons=["Gold","Silver","Bronze"];dragons.forEach(dragon=>{for(let copy=0;copy<4;copy++)this.gameState.tiles.push({id:tileId++,type:"dragons",value:dragon,suit:"honors",canMatch:other=>"dragons"===other.type&&other.value===dragon,display:this.createDragonTile(dragon),aria:`Dragon ${dragon}`})});const flowers=["Phalaenopsis","Cattleya","Dendrobium","Paphiopedilum","Vanda","Oncidium","Cymbidium","Masdevallia"];flowers.forEach(flower=>{this.gameState.tiles.push({id:tileId++,type:"flowers",value:flower,suit:"flowers",canMatch:other=>"flowers"===other.type,display:this.createFlowerTile(flower),aria:`Flower ${flower}`})}),this.shuffleTiles(),console.log(`Generated ${this.gameState.tiles.length} tiles`)}createPetalsTile(value){const petals="🌸".repeat(value);return`<div class="tile-content petals-tile"><div class="tile-number">${value}</div><div class="tile-symbols">${petals}</div><div class="tile-label">Petals</div></div>`}createStemsTile(value){const stems="🌿".repeat(value);return`<div class="tile-content stems-tile"><div class="tile-number">${value}</div><div class="tile-symbols">${stems}</div><div class="tile-label">Stems</div></div>`}createLabelsTile(value){const romans=["I","II","III","IV","V","VI","VII","VIII","IX"];return`<div class="tile-content labels-tile"><div class="tile-number">${value}</div><div class="tile-plaque"><div class="plaque-content">${romans[value-1]}</div><div class="plaque-orchid">🏵️</div></div><div class="tile-label">Labels</div></div>`}createWindTile(wind){const windIcons={N:"🌬️⬆️",E:"🌬️➡️",S:"🌬️⬇️",W:"🌬️⬅️"};return`<div class="tile-content winds-tile"><div class="tile-wind-icon">${windIcons[wind]}</div><div class="tile-wind-letter">${wind}</div><div class="tile-orchid-accent">🌺</div><div class="tile-label">Wind</div></div>`}createDragonTile(dragon){const dragonIcons={Gold:"🏆🥇",Silver:"🏅🥈",Bronze:"🎖️🥉"};return`<div class="tile-content dragons-tile"><div class="tile-dragon-icon">${dragonIcons[dragon]}</div><div class="tile-dragon-name">${dragon}</div><div class="tile-orchid-rosette">🌹</div><div class="tile-label">Dragon</div></div>`}createFlowerTile(flower){const flowerIcons={Phalaenopsis:"🦋🌺",Cattleya:"👑🌸",Dendrobium:"🌿💜",Paphiopedilum:"👞🌼",Vanda:"💙🌟",Oncidium:"☀️🌻",Cymbidium:"🗾🌷",Masdevallia:"🔺🌹"};return`<div class="tile-content flowers-tile"><div class="tile-flower-icon">${flowerIcons[flower]}</div><div class="tile-flower-name">${flower}</div><div class="tile-label">Flower</div></div>`}shuffleTiles(){for(let i=this.gameState.tiles.length-1;i>0;i--){const j=Math.floor(Math.random()*(i+1));[this.gameState.tiles[i],this.gameState.tiles[j]]=[this.gameState.tiles[j],this.gameState.tiles[i]]}}createLayout(){const board=document.getElementById("om-board");board.innerHTML="";const layoutName=this.options.layout,pattern=this.getLayoutPattern(layoutName);pattern.forEach((position,index)=>{if(index<this.gameState.tiles.length){const tile=this.gameState.tiles[index],tileElement=this.createTileElement(tile,position);board.appendChild(tileElement)}}),this.updateFreeTiles(),this.updateUI()}getLayoutPattern(layoutName){const patterns={turtle:this.getTurtlePattern(),dragon:this.getDragonPattern(),pyramid:this.getPyramidPattern(),orchid:this.getOrchidPattern(),greenhouse:this.getGreenhousePattern(),butterfly:this.getButterflyPattern(),fortress:this.getFortressPattern(),garland:this.getGarlandPattern()};return patterns[layoutName]||patterns.turtle}getTurtlePattern(){const positions=[];for(let row=0;row<8;row++)for(let col=0;col<16;col++)this.isTurtlePosition(row,col,0)&&positions.push({x:60*col,y:80*row,z:0,layer:0});for(let row=1;row<7;row++)for(let col=2;col<14;col++)this.isTurtlePosition(row,col,1)&&positions.push({x:60*col,y:80*row,z:10,layer:1});for(let row=2;row<6;row++)for(let col=4;col<12;col++)this.isTurtlePosition(row,col,2)&&positions.push({x:60*col,y:80*row,z:20,layer:2});return positions.slice(0,144)}isTurtlePosition(row,col,layer){return 0===layer?row>=1&&row<=6&&col>=1&&col<=14&&!(1===row&&(col<=2||col>=13))&&!(6===row&&(col<=2||col>=13)):1===layer?row>=2&&row<=5&&col>=3&&col<=12&&!(2===row&&(col<=4||col>=11))&&!(5===row&&(col<=4||col>=11)):row>=3&&row<=4&&col>=5&&col<=10}getDragonPattern(){return this.getTurtlePattern()}getPyramidPattern(){const positions=[];let tileCount=0;for(let layer=0;layer<8&&tileCount<144;layer++){const size=15-2*layer;for(let row=0;row<size&&tileCount<144;row++)for(let col=0;col<size&&tileCount<144;col++)positions.push({x:(col+layer)*60,y:(row+layer)*80,z:10*layer,layer:layer}),tileCount++}return positions.slice(0,144)}getOrchidPattern(){return this.getTurtlePattern()}getGreenhousePattern(){return this.getTurtlePattern()}getButterflyPattern(){return this.getTurtlePattern()}getFortressPattern(){return this.getTurtlePattern()}getGarlandPattern(){return this.getTurtlePattern()}createTileElement(tile,position){const element=document.createElement("div");return element.className="mahjong-tile",element.dataset.tileId=tile.id,element.dataset.type=tile.type,element.dataset.value=tile.value,element.tabIndex=0,element.setAttribute("role","button"),element.setAttribute("aria-label",tile.aria),element.style.left=position.x+"px",element.style.top=position.y+"px",element.style.zIndex=position.layer+1,position.z>0&&(element.style.transform=`translateZ(${position.z}px)`,element.classList.add("elevated")),element.innerHTML=tile.display,element}updateFreeTiles(){const tiles=document.querySelectorAll(".mahjong-tile");tiles.forEach(tile=>{const isFree=this.isTileFree(tile);tile.classList.toggle("free",isFree),tile.tabIndex=isFree?0:-1})}isTileFree(tileElement){if(this.gameState.matchedTiles.has(parseInt(tileElement.dataset.tileId)))return!1;const rect=tileElement.getBoundingClientRect(),layer=parseInt(tileElement.style.zIndex)-1,tilesAbove=Array.from(document.querySelectorAll(".mahjong-tile")).filter(other=>{if(other===tileElement)return!1;if(this.gameState.matchedTiles.has(parseInt(other.dataset.tileId)))return!1;const otherRect=other.getBoundingClientRect(),otherLayer=parseInt(other.style.zIndex)-1;return otherLayer>layer&&Math.abs(otherRect.left-rect.left)<50&&Math.abs(otherRect.top-rect.top)<50});if(tilesAbove.length>0)return!1;const leftBlocked=this.isSideBlocked(tileElement,-60,0),rightBlocked=this.isSideBlocked(tileElement,60,0);return!leftBlocked||!rightBlocked}isSideBlocked(tileElement,deltaX,deltaY){const rect=tileElement.getBoundingClientRect(),layer=parseInt(tileElement.style.zIndex)-1,blockingTiles=Array.from(document.querySelectorAll(".mahjong-tile")).filter(other=>{if(other===tileElement)return!1;if(this.gameState.matchedTiles.has(parseInt(other.dataset.tileId)))return!1;const otherRect=other.getBoundingClientRect(),otherLayer=parseInt(other.style.zIndex)-1;return otherLayer===layer&&Math.abs(otherRect.left-(rect.left+deltaX))<30&&Math.abs(otherRect.top-(rect.top+deltaY))<30});return blockingTiles.length>0}selectTile(tileElement){const tileId=parseInt(tileElement.dataset.tileId),tile=this.gameState.tiles.find(t=>t.id===tileId);if(!tile||!this.isTileFree(tileElement)||this.gameState.matchedTiles.has(tileId))return;if(this.gameState.selectedTiles.includes(tileId))return this.gameState.selectedTiles=this.gameState.selectedTiles.filter(id=>id!==tileId),tileElement.classList.remove("selected"),void this.announce(`Deselected ${tile.aria}`);this.gameState.selectedTiles.length>=2&&this.clearSelection(),this.gameState.selectedTiles.push(tileId),tileElement.classList.add("selected"),this.announce(`Selected ${tile.aria}. ${this.gameState.selectedTiles.length} of 2 tiles selected.`),2===this.gameState.selectedTiles.length&&setTimeout(()=>this.checkMatch(),300)}checkMatch(){if(2!==this.gameState.selectedTiles.length)return;const[tileId1,tileId2]=this.gameState.selectedTiles,tile1=this.gameState.tiles.find(t=>t.id===tileId1),tile2=this.gameState.tiles.find(t=>t.id===tileId2),element1=document.querySelector(`[data-tile-id="${tileId1}"]`),element2=document.querySelector(`[data-tile-id="${tileId2}"]`),isMatch=tile1.canMatch(tile2);isMatch?(this.gameState.matchedTiles.add(tileId1),this.gameState.matchedTiles.add(tileId2),element1.classList.remove("selected"),element2.classList.remove("selected"),element1.classList.add("matched"),element2.classList.add("matched"),this.gameState.moves++,this.gameState.score+=this.calculateScore(),this.saveStateForUndo(),this.announce(`Match found! ${this.getRemainingPairs()} pairs remaining.`),this.emit("match",{tile1:tile1,tile2:tile2,score:this.gameState.score}),this.gameState.matchedTiles.size===this.gameState.tiles.length&&this.handleWin()):(element1.classList.remove("selected"),element2.classList.remove("selected"),this.announce("No match. Try again.")),this.gameState.selectedTiles=[],this.updateFreeTiles(),this.updateUI()}calculateScore(){let baseScore=100;const timeElapsed=(Date.now()-this.gameState.startTime)/1e3,timeBonus=Math.max(0,300-timeElapsed)*2,moveBonus=Math.max(0,72-this.gameState.moves)*10;return Math.round(baseScore+timeBonus+moveBonus)}getRemainingPairs(){return(this.gameState.tiles.length-this.gameState.matchedTiles.size)/2}clearSelection(){this.gameState.selectedTiles.forEach(tileId=>{const element=document.querySelector(`[data-tile-id="${tileId}"]`);element&&element.classList.remove("selected")}),this.gameState.selectedTiles=[]}saveStateForUndo(){this.gameState.undoStack.push({matchedTiles:new Set(this.gameState.matchedTiles),moves:this.gameState.moves,score:this.gameState.score}),this.gameState.undoStack.length>50&&this.gameState.undoStack.shift(),this.gameState.redoStack=[]}undo(){0!==this.gameState.undoStack.length&&(this.gameState.redoStack.push({matchedTiles:new Set(this.gameState.matchedTiles),moves:this.gameState.moves,score:this.gameState.score}),this.gameState.matchedTiles=(previousState=this.gameState.undoStack.pop()).matchedTiles,this.gameState.moves=previousState.moves,this.gameState.score=previousState.score,this.updateTileStates(),this.updateFreeTiles(),this.updateUI(),this.announce("Move undone"),this.emit("undo"));var previousState}redo(){0!==this.gameState.redoStack.length&&(this.saveStateForUndo(),this.gameState.matchedTiles=(nextState=this.gameState.redoStack.pop()).matchedTiles,this.gameState.moves=nextState.moves,this.gameState.score=nextState.score,this.updateTileStates(),this.updateFreeTiles(),this.updateUI(),this.announce("Move redone"),this.emit("redo"));var nextState}updateTileStates(){document.querySelectorAll(".mahjong-tile").forEach(element=>{const tileId=parseInt(element.dataset.tileId);element.classList.toggle("matched",this.gameState.matchedTiles.has(tileId))})}showHint(){const possibleMatch=this.findPossibleMatch();if(possibleMatch){const[tileId1,tileId2]=possibleMatch,element1=document.querySelector(`[data-tile-id="${tileId1}"]`),element2=document.querySelector(`[data-tile-id="${tileId2}"]`);element1.classList.add("hint"),element2.classList.add("hint"),setTimeout(()=>{element1.classList.remove("hint"),element2.classList.remove("hint")},2e3),this.announce("Hint shown - two matching tiles are highlighted"),this.emit("hint",possibleMatch)}else this.announce("No possible matches found. Try shuffling.")}findPossibleMatch(){const freeTiles=Array.from(document.querySelectorAll(".mahjong-tile.free")).map(el=>parseInt(el.dataset.tileId)).filter(id=>!this.gameState.matchedTiles.has(id));for(let i=0;i<freeTiles.length;i++)for(let j=i+1;j<freeTiles.length;j++){const tile1=this.gameState.tiles.find(t=>t.id===freeTiles[i]),tile2=this.gameState.tiles.find(t=>t.id===freeTiles[j]);if(tile1.canMatch(tile2))return[freeTiles[i],freeTiles[j]]}return null}shuffleTiles(){this.clearSelection();const unmatchedTiles=this.gameState.tiles.filter(tile=>!this.gameState.matchedTiles.has(tile.id));for(let i=unmatchedTiles.length-1;i>0;i--){const j=Math.floor(Math.random()*(i+1)),element1=document.querySelector(`[data-tile-id="${unmatchedTiles[i].id}"]`),element2=document.querySelector(`[data-tile-id="${unmatchedTiles[j].id}"]`);if(element1&&element2){const temp=element1.innerHTML;element1.innerHTML=element2.innerHTML,element2.innerHTML=temp;const tempType=element1.dataset.type,tempValue=element1.dataset.value;element1.dataset.type=element2.dataset.type,element1.dataset.value=element2.dataset.value,element2.dataset.type=tempType,element2.dataset.value=tempValue}}this.updateFreeTiles(),this.announce("Tiles shuffled"),this.emit("shuffle")}newGame(){this.gameState={tiles:[],selectedTiles:[],matchedTiles:new Set,moves:0,score:0,startTime:Date.now(),endTime:null,isPaused:!1,undoStack:[],redoStack:[]},this.generateTiles(),this.createLayout(),this.startTimer(),this.updateUI(),this.announce("New game started"),this.emit("newGame")}handleWin(){this.gameState.endTime=Date.now();const duration=this.gameState.endTime-this.gameState.startTime;document.getElementById("om-win-time").textContent=this.formatTime(duration/1e3),document.getElementById("om-win-moves").textContent=this.gameState.moves,document.getElementById("om-win-score").textContent=this.gameState.score,document.getElementById("om-win-overlay").style.display="flex",this.announce(`Congratulations! Game completed in ${this.formatTime(duration/1e3)} with ${this.gameState.moves} moves and ${this.gameState.score} points.`),this.emit("win",{time:duration,moves:this.gameState.moves,score:this.gameState.score}),this.saveStatistics()}startTimer(){this.timerInterval&&clearInterval(this.timerInterval),this.gameState.startTime=Date.now(),this.timerInterval=setInterval(()=>{if(!this.gameState.isPaused&&!this.gameState.endTime){const elapsed=(Date.now()-this.gameState.startTime)/1e3;document.getElementById("om-timer").textContent=this.formatTime(elapsed)}},1e3)}formatTime(seconds){const mins=Math.floor(seconds/60),secs=Math.floor(seconds%60);return`${mins.toString().padStart(2,"0")}:${secs.toString().padStart(2,"0")}`}updateUI(){document.getElementById("om-moves").textContent=this.gameState.moves,document.getElementById("om-score").textContent=this.gameState.score,document.getElementById("om-pairs").textContent=this.getRemainingPairs(),document.getElementById("om-undo").disabled=0===this.gameState.undoStack.length,document.getElementById("om-redo").disabled=0===this.gameState.redoStack.length}applyTheme(themeName){const theme=THEMES[themeName];if(!theme)return;const widget=this.container.querySelector(".orchid-mahjong-widget");widget.dataset.theme=themeName,widget.style.setProperty("--om-primary",theme.primary),widget.style.setProperty("--om-secondary",theme.secondary),widget.style.setProperty("--om-accent",theme.accent),widget.style.setProperty("--om-background",theme.background),widget.style.setProperty("--om-tile",theme.tile),widget.style.setProperty("--om-selected",theme.selected),widget.style.setProperty("--om-matched",theme.matched),this.options.theme=themeName,this.saveSettings()}bindEvents(){const board=document.getElementById("om-board");board.addEventListener("click",e=>{const tile=e.target.closest(".mahjong-tile");tile&&this.selectTile(tile)}),document.getElementById("om-undo").addEventListener("click",()=>this.undo()),document.getElementById("om-redo").addEventListener("click",()=>this.redo()),document.getElementById("om-hint").addEventListener("click",()=>this.showHint()),document.getElementById("om-shuffle").addEventListener("click",()=>this.shuffleTiles()),document.getElementById("om-new").addEventListener("click",()=>this.newGame()),document.getElementById("om-settings").addEventListener("click",()=>{document.getElementById("om-settings-panel").style.display="block"}),document.getElementById("om-close-settings").addEventListener("click",()=>{document.getElementById("om-settings-panel").style.display="none"}),document.getElementById("om-theme-select").addEventListener("change",e=>{this.applyTheme(e.target.value)}),document.getElementById("om-layout-select").addEventListener("change",e=>{this.options.layout=e.target.value,this.newGame()}),document.getElementById("om-highlights").addEventListener("change",e=>{this.options.highlights=e.target.checked,this.saveSettings()}),document.getElementById("om-sound").addEventListener("change",e=>{this.options.sound=e.target.checked,this.saveSettings()}),document.getElementById("om-play-again").addEventListener("click",()=>{document.getElementById("om-win-overlay").style.display="none",this.newGame()}),document.getElementById("om-change-layout").addEventListener("click",()=>{document.getElementById("om-win-overlay").style.display="none",document.getElementById("om-settings-panel").style.display="block"}),this.bindKeyboardEvents()}bindKeyboardEvents(){document.addEventListener("keydown",e=>{if(e.target.closest(".orchid-mahjong-widget"))switch(e.key.toLowerCase()){case"h":e.preventDefault(),this.showHint();break;case"u":e.preventDefault(),this.undo();break;case"r":e.preventDefault(),this.redo();break;case"s":e.preventDefault(),this.shuffleTiles();break;case"t":e.preventDefault(),this.newGame();break;case"enter":case" ":e.target.classList.contains("mahjong-tile")&&(e.preventDefault(),this.selectTile(e.target));break;case"arrowleft":case"arrowright":case"arrowup":case"arrowdown":e.preventDefault(),this.navigateTiles(e.key)}})}navigateTiles(direction){const currentTile=document.activeElement;if(!currentTile.classList.contains("mahjong-tile"))return;const allTiles=Array.from(document.querySelectorAll(".mahjong-tile.free")),currentIndex=allTiles.indexOf(currentTile);let nextIndex=currentIndex;switch(direction){case"ArrowLeft":nextIndex=currentIndex>0?currentIndex-1:allTiles.length-1;break;case"ArrowRight":nextIndex=currentIndex<allTiles.length-1?currentIndex+1:0;break;case"ArrowUp":nextIndex=Math.max(0,currentIndex-8);break;case"ArrowDown":nextIndex=Math.min(allTiles.length-1,currentIndex+8)}allTiles[nextIndex]&&allTiles[nextIndex].focus()}announce(message){document.getElementById("om-announcements").textContent=message}saveSettings(){const settings={theme:this.options.theme,layout:this.options.layout,sound:this.options.sound,highlights:this.options.highlights};localStorage.setItem("orchid-mahjong-settings",JSON.stringify(settings))}loadSettings(){try{const settings=JSON.parse(localStorage.getItem("orchid-mahjong-settings")||"{}");this.options={...this.options,...settings},document.getElementById("om-theme-select").value=this.options.theme,document.getElementById("om-layout-select").value=this.options.layout,document.getElementById("om-highlights").checked=this.options.highlights,document.getElementById("om-sound").checked=this.options.sound}catch(e){console.warn("Failed to load settings:",e)}}saveStatistics(){try{const stats=JSON.parse(localStorage.getItem("orchid-mahjong-stats")||"{}"),layoutName=this.options.layout;stats[layoutName]||(stats[layoutName]={bestTime:1/0,bestScore:0,gamesPlayed:0});const duration=this.gameState.endTime-this.gameState.startTime;stats[layoutName].gamesPlayed++,duration<stats[layoutName].bestTime&&(stats[layoutName].bestTime=duration),this.gameState.score>stats[layoutName].bestScore&&(stats[layoutName].bestScore=this.gameState.score),localStorage.setItem("orchid-mahjong-stats",JSON.stringify(stats))}catch(e){console.warn("Failed to save statistics:",e)}}on(eventName,handler){this.eventHandlers[eventName]||(this.eventHandlers[eventName]=[]),this.eventHandlers[eventName].push(handler)}off(eventName,handler){this.eventHandlers[eventName]&&(this.eventHandlers[eventName]=this.eventHandlers[eventName].filter(h=>h!==handler))}emit(eventName,data){this.eventHandlers[eventName]&&this.eventHandlers[eventName].forEach(handler=>{try{handler(data)}catch(e){console.error("Event handler error:",e)}})}setTheme(themeName){this.applyTheme(themeName)}getStats(){try{return JSON.parse(localStorage.getItem("orchid-mahjong-stats")||"{}")}catch(e){return{}}}resetStats(){localStorage.removeItem("orchid-mahjong-stats"),this.announce("Statistics reset")}destroy(){this.timerInterval&&clearInterval(this.timerInterval),this.container.innerHTML=""}}window.OrchidMahjong.init=function(selector,options){const container="string"==typeof selector?document.querySelector(selector):selector;return container?new OrchidMahjongGame(container,options):(console.error("OrchidMahjong: Container not found"),null)},window.OrchidMahjong.Game=OrchidMahjongGame,window.OrchidMahjong.THEMES=THEMES,window.OrchidMahjong.LAYOUTS=LAYOUTS,document.addEventListener("DOMContentLoaded",()=>{document.querySelectorAll("[data-orchid-mahjong]").forEach(element=>{const options={};element.dataset.theme&&(options.theme=element.dataset.theme),element.dataset.layout&&(options.layout=element.dataset.layout),window.OrchidMahjong.init(element,options)})})}();